import pandas as pd   
import pickle
from decision_company import read_csv_file, count_unique_values

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")   
  
# Descriptive statistics for employment status  
employment_column = credit_customers['employment'] 
employment_counts = count_unique_values(employment_column)  

print("\nEmployment Status Distribution:")  
print(employment_counts) 
pickle.dump(employment_counts,open("./ref_result/employment_counts.pkl","wb"))